import { addca3a7e9c7649ae } from "../internal/a69125a36514bd909/addca3a7e9c7649ae";
import { adf376bf8c37e5ab5 } from "../internal/a69125a36514bd909/adf376bf8c37e5ab5";
import { abe91a6ea5ad082f7 } from "../internal/a69125a36514bd909/abe91a6ea5ad082f7";
/* eslint-disable @typescript-eslint/no-explicit-any */
export class DocumentBuilder extends addca3a7e9c7649ae {
    _parameters;
    topContentsIndex = 0;
    constructor() {
        super();
        this._parameters = new Map([
            ["category", "Document"],
            ["contents", new Array()],
        ]);
    }
    settingTopMargin(height) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.splice(this.topContentsIndex, 0, new Map([
                ["method", "Setting.TopMargin"],
                ["parameter", new Map([["height", height]])],
            ]));
            this.topContentsIndex++;
        });
        return this;
    }
    settingBlackMark(parameter) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.splice(this.topContentsIndex, 0, new Map([
                ["method", "Setting.BlackMark"],
                [
                    "parameter",
                    new Map([
                        ["enable", parameter.enable],
                        [
                            "position",
                            abe91a6ea5ad082f7.convertBlackMarkPosition(parameter.position),
                        ],
                    ]),
                ],
            ]));
            this.topContentsIndex++;
        });
        return this;
    }
    settingLabel(parameter) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.splice(this.topContentsIndex, 0, new Map([
                ["method", "Setting.Label"],
                ["parameter", new Map([["enable", parameter.enable]])],
            ]));
            this.topContentsIndex++;
        });
        return this;
    }
    settingHoldPrint(parameter) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.splice(this.topContentsIndex, 0, new Map([
                ["method", "Setting.HoldPrint"],
                ["parameter", new Map([["enable", parameter.enable]])],
            ]));
            this.topContentsIndex++;
        });
        return this;
    }
    settingPrintableArea(width) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.splice(this.topContentsIndex, 0, new Map([
                ["method", "Setting.PrintableArea"],
                ["parameter", new Map([["width", width]])],
            ]));
            this.topContentsIndex++;
        });
        return this;
    }
    addPrinter(builder) {
        this._addChild(builder);
        this._addAction(async () => {
            if (builder._parameter !== undefined) {
                adf376bf8c37e5ab5.addPrinterParameter(builder._parameters, builder._parameter);
            }
            const contents = this._parameters.get("contents");
            contents.push(builder._parameters);
        });
        return this;
    }
    addDrawer(builder) {
        this._addChild(builder);
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(builder._parameters);
        });
        return this;
    }
    addBuzzer(builder) {
        this._addChild(builder);
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(builder._parameters);
        });
        return this;
    }
    addMelodySpeaker(builder) {
        this._addChild(builder);
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(builder._parameters);
        });
        return this;
    }
    addDisplay(builder) {
        this._addChild(builder);
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            contents.push(builder._parameters);
        });
        return this;
    }
    addRaw(content) {
        this._addAction(async () => {
            const contents = this._parameters.get("contents");
            const numberArray = Uint8Array.from(content);
            const base64String = Buffer.from(numberArray).toString("base64");
            contents.push(new Map([
                ["method", "Raw.Send"],
                ["parameter", new Map([["content", base64String]])],
            ]));
        });
        return this;
    }
}
